<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-15 16:22:51
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class RedEnvelopeActivity
 */
class RedEnvelopeActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\RedEnvelopeActivity";

    /**
     * 获取用户行为记录列表
     *
     */
    public static function getUserBehaviors (): \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO"
        );
    }
    /**
     * 通过userId获取用户行为记录列表
     *
     */
    public static function getUserBehaviorsByUserId (int $userId): \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviorsByUserId(["userId" => $userId, ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\UserBehaviorDTO"
        );
    }
    /**
     * 创建用户行为记录
     *
     */
    public static function createUserBehaviorRecord (string $behavior): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecord(["behavior" => $behavior, ]);
    }
    /**
     * 通过userId创建用户行为记录
     *
     */
    public static function createUserBehaviorRecordByUserId (string $behavior, int $userId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecordByUserId(["behavior" => $behavior, "userId" => $userId, ]);
    }
    /**
     * 通过behavior获取对应的userId列表--预约端调用
     *
     */
    public static function getUserIdsByBehavior (string $behavior): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserIdsByBehavior(["behavior" => $behavior, ]);
    }
    /**
     * 获取新年活动信息
     *
     */
    public static function getActivityInfo (): \Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\ActivityInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\RedEnvelopeActivity\DTO\ActivityInfoDTO"
        );
    }
    /**
     * 获取红包活动分享海报二维码
     *
     */
    public static function getPosterQrcode (int $greetingId): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPosterQrcode(["greetingId" => $greetingId, ]);
    }
    /**
     * 获取红包金额明细
     *
     */
    public static function getRedEnvelopeAmountDetails (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getRedEnvelopeAmountDetails();
    }
    /**
     * 用户参与详情
     *
     */
    public static function getParticipationDetail (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getParticipationDetail();
    }
    /**
     * 获取用户惊喜红包详情
     *
     */
    public static function getAssistanceRedEnvelopeDetail (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAssistanceRedEnvelopeDetail();
    }
    /**
     * 开红包
     *
     */
    public static function openRedEnvelope (string $type, int $fromUser, int $greetingId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->openRedEnvelope(["type" => $type, "fromUser" => $fromUser, "greetingId" => $greetingId, ]);
    }
    /**
     * 根据id获取用户脱敏详情
     *
     */
    public static function getUserInfoByUserId (int $userId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserInfoByUserId(["userId" => $userId, ]);
    }
    /**
     * 重置用户行为记录
     *
     */
    public static function resetUserBehaviorRecord (string $behavior): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->resetUserBehaviorRecord(["behavior" => $behavior, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}