<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-12 17:59:15
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class SpreadPlan
 */
class SpreadPlan {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Push\\SpreadPlan";

    /**
     * 创建推广计划
     *
     */
    public static function createSpreadPlan (string $task_name, string $description, string $brand, string $relation_activity_id, string $channel, string $push_at, array $filter_condition, array $push_content, array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createSpreadPlan(["task_name" => $task_name, "description" => $description, "brand" => $brand, "relation_activity_id" => $relation_activity_id, "channel" => $channel, "push_at" => $push_at, "filter_condition" => $filter_condition, "push_content" => $push_content, "extend" => $extend, ]);
    }
    /**
     * 编辑推广计划
     *
     */
    public static function editSpreadPlan (int $task_id, string $brand, string $task_name, string $description, string $relation_activity_id, string $channel, string $push_at, array $filter_condition, array $push_content, array $extend): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->editSpreadPlan(["task_id" => $task_id, "brand" => $brand, "task_name" => $task_name, "description" => $description, "relation_activity_id" => $relation_activity_id, "channel" => $channel, "push_at" => $push_at, "filter_condition" => $filter_condition, "push_content" => $push_content, "extend" => $extend, ]);
    }
    /**
     * 推广计划取消
     *
     */
    public static function cancelSpreadPlan (int $task_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelSpreadPlan(["task_id" => $task_id, ]);
    }
    /**
     * 删除推广计划
     *
     */
    public static function deleteSpreadPlan (int $task_id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteSpreadPlan(["task_id" => $task_id, ]);
    }
    /**
     * 推广计划详情
     *
     */
    public static function spreadPlanDetail (int $task_id): \Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanDetail(["task_id" => $task_id, ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskDetailDTO"
        );
    }
    /**
     * 推广计划列表
     *
     */
    public static function spreadPlanList (?\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\Cmd\PushTaskListCmd $pushTaskListCmd = null): \Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->spreadPlanList($pushTaskListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PushTask\DTO\PushTaskListDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}