<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-01-16 11:36:35
 */
namespace Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd;

class MomentUpdateCmd {
    /**
     * @var  int
     * 朋友圈id
     * validation: 
     */
    public int $id;
    /**
     * @var  string
     * 品牌
     * validation: required|in:blue,gold
     */
    public string $brand;
    /**
     * @var  string
     * 朋友圈内容
     * validation: 
     */
    public string $content;
    /**
     * @var  array
     * 朋友圈内容素材
     * validation: required|wechat_work_material
     */
    public array $material;
    /**
     * @var  null|string
     * 发布时间
     * validation: sometimes|date_format:Y-m-d H:i:s
     */
    public ?string $published_at = null;
    /**
     * @var  int[]
     * 朋友圈发布范围
     * validation: 
     */
    public array $store_ids;
    /**
     * @var  string
     * 朋友圈类型
     * validation: required|in:video,web_page,graphic
     */
    public string $type;

    public function __construct (int $currentManageStaffId, int $id, string $brand, string $content, array $material, array $store_ids, string $type) {
        $this->currentManageStaffId = $currentManageStaffId;
        $this->id = $id;
        $this->brand = $brand;
        $this->content = $content;
        $this->material = $material;
        $this->store_ids = $store_ids;
        $this->type = $type;
    }

    public static function create(int $currentManageStaffId, int $id, string $brand, string $content, array $material, array $store_ids, string $type): self {
        return new self($currentManageStaffId, $id, $brand, $content, $material, $store_ids, $type);
    }

    public function setId(int $id): self {
        $this->id = $id;

        return $this;
    }

    public function setBrand(string $brand): self {
        $this->brand = $brand;

        return $this;
    }

    public function setContent(string $content): self {
        $this->content = $content;

        return $this;
    }

    public function setMaterial(array $material): self {
        $this->material = $material;

        return $this;
    }

    public function setPublishedAt(?string $published_at): self {
        $this->published_at = $published_at;

        return $this;
    }

    public function setStoreIds(array $store_ids): self {
        $this->store_ids = $store_ids;

        return $this;
    }

    public function setType(string $type): self {
        $this->type = $type;

        return $this;
    }
}