<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-18 11:56:28
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class YearBillActivity
 */
class YearBillActivity {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Mobile\\Activity\\YearBillActivity";

    /**
     * 图片内容审核
     *
     */
    public static function imageCensor (string $imgUrl): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->imageCensor(["imgUrl" => $imgUrl, ]);
    }
    /**
     * 校验用户是否为新用户
     *
     */
    public static function checkIsNewUser (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkIsNewUser();
    }
    /**
     * 获取用户标签组
     *
     */
    public static function getUserTagGroup (int $user_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserTagGroup(["user_id" => $user_id, ]);
    }
    /**
     * 获取歌单列表
     *
     */
    public static function getMusics (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMusics(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\MusicConfigDetailDTO[]"
        );
    }
    /**
     * 获取时刻列表
     *
     */
    public static function getMoments (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMoments(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\MomentConfigDetailDTO[]"
        );
    }
    /**
     * 创建用户时光相册
     *
     */
    public static function createTimeAlbum (int $musicId, array $moments): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->createTimeAlbum(["musicId" => $musicId, "moments" => $moments, ]);
    }
    /**
     * 编辑用户时光相册
     *
     */
    public static function updateTimeAlbum (int $musicId, array $moments): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateTimeAlbum(["musicId" => $musicId, "moments" => $moments, ]);
    }
    /**
     * 获取指定用户的时光相册信息
     *
     */
    public static function getUserTimeAlbum (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserTimeAlbum();
    }
    /**
     * 获取指定的相册信息
     *
     */
    public static function getPhotoAlbum (int $albumId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPhotoAlbum(["albumId" => $albumId, ]);
    }
    /**
     * 获取时光广场列表信息
     *
     */
    public static function getTimeSquareList (int $page, int $pageSize, array $excludeAlbumIds): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimeSquareList(["page" => $page, "pageSize" => $pageSize, "excludeAlbumIds" => $excludeAlbumIds, ]);
    }
    /**
     * 创建相册点赞记录
     *
     */
    public static function likedTimeAlbum (int $albumId): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->likedTimeAlbum(["albumId" => $albumId, ]);
    }
    /**
     * 创建用户行为记录
     *
     */
    public static function createUserBehaviorRecord (string $behavior): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehaviorRecord(["behavior" => $behavior, ]);
    }
    /**
     * 获取用户行为记录列表
     *
     */
    public static function getUserBehaviors (): \Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\UserBehaviorDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\UserBehaviorDTO"
        );
    }
    /**
     * 获取最新x条相册列表
     *
     */
    public static function getLatestAlbumList (int $num): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getLatestAlbumList(["num" => $num, ]);
    }
    /**
     * 获取时光相册海报二维码
     *
     */
    public static function getTimeAlbumPosterQrcode (string $brand): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTimeAlbumPosterQrcode(["brand" => $brand, ]);
    }
    /**
     * 分享时光相册到广场
     *
     */
    public static function shareAlbumToSquare (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->shareAlbumToSquare();
    }
    /**
     * 获取时光相册活动产品券领取数量
     *
     */
    public static function getProductCardReceivedNum (): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductCardReceivedNum();
    }
    /**
     * 获取时光相册活动时间
     *
     */
    public static function getYearBillActivityDate (): \Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\ActivityDateInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getYearBillActivityDate(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\ActivityDateInfoDTO"
        );
    }
    /**
     * 获取时光相册用户优惠券领取情况
     *
     */
    public static function getUserTimeAlbumCouponInfo (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserTimeAlbumCouponInfo();
    }
    /**
     * 获取用户成片列表
     *
     */
    public static function getUserFinishPhotos (int $user_id, int $page, int $pageSize): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserFinishPhotos(["user_id" => $user_id, "page" => $page, "pageSize" => $pageSize, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}