<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-18 15:19:19
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\WechatWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class MomentManage
 */
class MomentManage {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "WechatWork\\MomentManage";

    /**
     * 获取企业微信朋友圈列表
     *
     */
    public static function list (?\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentListCmd $momentListCmd = null): \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->list($momentListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentListDTO"
        );
    }
    /**
     * 获取单条企业微信朋友圈
     *
     */
    public static function getMoment (int $id): \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getMoment(["id" => $id, ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }
    /**
     * 删除企业微信朋友圈
     *
     */
    public static function deleteMoment (int $id): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteMoment(["id" => $id, ]);
    }
    /**
     * 编辑企业微信朋友圈
     *
     */
    public static function updateMoment (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentUpdateCmd $momentUpdateCmd): \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->updateMoment($momentUpdateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }
    /**
     * 创建企业微信朋友圈
     *
     */
    public static function createMoment (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentCreateCmd $momentCreateCmd): \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createMoment($momentCreateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }
    /**
     * 获取朋友圈页面设置
     *
     */
    public static function getMomentSetting (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMomentSetting();
    }
    /**
     * 保存朋友圈页面设置
     *
     */
    public static function saveMomentSetting (array $page_setting): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveMomentSetting(["page_setting" => $page_setting, ]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}