<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-18 15:33:01
 */
namespace Mainto\Bridge\Invokes\ProjectCrm\Common;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Common
 */
class Common {
    private static string $serviceName = "ProjectCrm";

    private static string $className = "Common\\Common";

    /**
     * 获取领券活动页
     *
     */
    public static function getPreferentialPageActivityList (string $category, string $name, string $template, string $status, int $page, int $page_size, bool $all) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialPageActivityList(["category" => $category, "name" => $name, "template" => $template, "status" => $status, "page" => $page, "page_size" => $page_size, "all" => $all, ]);
    }
    /**
     * 缦图产品列表
     *
     */
    public static function getMaintoProduct (int $category_id, string $name, string $full_name, bool $show_deleted, string $module, string $status, bool $c_hidden) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaintoProduct(["category_id" => $category_id, "name" => $name, "full_name" => $full_name, "show_deleted" => $show_deleted, "module" => $module, "status" => $status, "c_hidden" => $c_hidden, ]);
    }
    /**
     * 根据筛选条件获取人数
     *
     */
    public static function getPeopleCount (array $tags): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getPeopleCount(["tags" => $tags, ]);
    }
    /**
     * 上传图片
     *
     */
    public static function upLoadImage (string $img_path) {
        return RpcClass::getClass(self::$serviceName, self::$className)->upLoadImage(["img_path" => $img_path, ]);
    }
    /**
     * getManagerInfo
     *
     */
    public static function getManagerInfo (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getManagerInfo();
    }
    /**
     * 根据城市id获取门店企业微信信息
     *
     */
    public static function getStoreListByCityId (array $city_ids, array $store_type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId(["city_ids" => $city_ids, "store_type" => $store_type, ]);
    }
    /**
     * 获取活动可用门店列表Ids
     *
     */
    public static function getActivityAvailableStoreList (int $activity_id, string $activity_type, int $product_category_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityAvailableStoreList(["activity_id" => $activity_id, "activity_type" => $activity_type, "product_category_id" => $product_category_id, ]);
    }
    /**
     * 获取可参与活动的门店树
     *
     */
    public static function getAvailableStoreTree (int $product_category_id, string $brand): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableStoreTree(["product_category_id" => $product_category_id, "brand" => $brand, ]);
    }
    /**
     * 批量获取产品的折扣规则
     *
     */
    public static function getProductDiscountList (array $discount_rule_ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getProductDiscountList(["discount_rule_ids" => $discount_rule_ids, ]);
    }
    /**
     * 获取活动门店中距离最近的门店
     *
     */
    public static function getMostNearestStore (array $location, int $activity_id, int $product_category_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStore(["location" => $location, "activity_id" => $activity_id, "product_category_id" => $product_category_id, ]);
    }
    /**
     * 通过品牌获取最近的门店
     *
     */
    public static function getMostNearestStoreByBrand (array $location, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMostNearestStoreByBrand(["location" => $location, "brand" => $brand, ]);
    }
    /**
     * 获取活动链接参数
     *
     */
    public static function getActivityLinkParameter (int $link_parameter_id, int $index): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getActivityLinkParameter(["link_parameter_id" => $link_parameter_id, "index" => $index, ]);
    }
    /**
     * 保存活动链接参数
     *
     */
    public static function saveActivityLinkParameter ( $activity_id, array $link_parameter): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->saveActivityLinkParameter(["activity_id" => $activity_id, "link_parameter" => $link_parameter, ]);
    }
    /**
     * 获取微信小程序UrlLink
     *
     */
    public static function getMiniUrlLink (string $app_name, string $path, string $query): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniUrlLink(["app_name" => $app_name, "path" => $path, "query" => $query, ]);
    }
    /**
     * 获取二维码
     *
     */
    public static function getQrcode (string $path): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getQrcode(["path" => $path, ]);
    }
    /**
     * 根据产品id列表获取可用门店
     *
     */
    public static function getAvailableStoreIdsByProductIds (array $product_ids, array $store_ids): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAvailableStoreIdsByProductIds(["product_ids" => $product_ids, "store_ids" => $store_ids, ]);
    }
    /**
     * 获取产品组产品信息
     *
     */
    public static function getCategoryProductInfo (int $activity_id, int $category_id, int $store_id, int $city_id, string $module): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryProductInfo(["activity_id" => $activity_id, "category_id" => $category_id, "store_id" => $store_id, "city_id" => $city_id, "module" => $module, ]);
    }
    /**
     * 获取产品组详情
     *
     */
    public static function getCategoryDetail (int $category_id): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCategoryDetail(["category_id" => $category_id, ]);
    }
    /**
     * 订阅小程序消息
     *
     */
    public static function subscribeMessage (string $brand, array $messages): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->subscribeMessage(["brand" => $brand, "messages" => $messages, ]);
    }
    /**
     * 分页获取优惠券列表
     *
     */
    public static function getPreferentialTemplateList (\Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\Cmd\PreferentialTemplateListCmd $preferentialTemplateListCmd): \Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\DTO\PreferentialTemplateListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPreferentialTemplateList($preferentialTemplateListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\PreferentialTemplate\DTO\PreferentialTemplateListDTO"
        );
    }
    /**
     * 获取成片列表
     *
     */
    public static function getUserFinishPhotoList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\Cmd\UserFinishPhotoListCmd $userFinishPhotoListCmd): \Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\DTO\UserFinishPhotoListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserFinishPhotoList($userFinishPhotoListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserFinishPhoto\DTO\UserFinishPhotoListDTO"
        );
    }
    /**
     * 图片内容审核
     *
     */
    public static function imageCensor (\Mainto\Bridge\Structs\ProjectCrm\Common\ImageCensor\Cmd\GreenImageCheckCmd $greenImageCheckCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->imageCensor($greenImageCheckCmd);
    }
    /**
     * 是否已订阅过当前事件
     *
     */
    public static function isSubscribedMessage (\Mainto\Bridge\Structs\ProjectCrm\Mobile\SubscribeMessage\Cmd\SubscribedMessageCheckCmd $subscribedMessageCheckCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->isSubscribedMessage($subscribedMessageCheckCmd);
    }
    /**
     * 获取用户基础信息
     *
     */
    public static function getUserBaseInfo (\Mainto\Bridge\Structs\ProjectCrm\Common\User\Cmd\UserBaseInfoCmd $userBaseInfoCmd): \Mainto\Bridge\Structs\ProjectCrm\Common\User\DTO\UserBaseInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getUserBaseInfo($userBaseInfoCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\User\DTO\UserBaseInfoDTO"
        );
    }
    /**
     * 获取服务器当前时间戳
     *
     */
    public static function getCurrentServerTimestamp (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCurrentServerTimestamp();
    }
    /**
     * 转换内容为base64
     *
     */
    public static function convertToBase64 (string $content): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->convertToBase64(["content" => $content, ]);
    }
    /**
     * 获取省份列表
     *
     */
    public static function getProvinceList (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getProvinceList(),
            "\Mainto\Bridge\Structs\ProjectCrm\Common\Area\DTO\ProvinceInfoDTO[]"
        );
    }
    /**
     * 创建一个计数器
     *
     */
    public static function createCounter (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\CreateCounterCMD $createCounterCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createCounter($createCounterCMD);
    }
    /**
     * 设置计数器剩余
     *
     */
    public static function setCounterRemaining (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\SetCounterRemainingCMD $setCounterRemainingCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->setCounterRemaining($setCounterRemainingCMD);
    }
    /**
     * 获取计数器剩余
     *
     */
    public static function getCounterRemaining (\Mainto\Bridge\Structs\ProjectCrm\Common\Counter\CMD\GetCounterRemainingCMD $getCounterRemainingCMD): int {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCounterRemaining($getCounterRemainingCMD);
    }
    /**
     * 创建用户行为记录
     *
     */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserBehavior\CMD\CreateUserBehaviorCMD $createUserBehaviorCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUserBehavior($createUserBehaviorCMD);
    }
    /**
     * 用户行为是否存在
     *
     */
    public static function isUserBehaviorExists (\Mainto\Bridge\Structs\ProjectCrm\Mobile\UserBehavior\CMD\BehaviorExistsCheckCMD $behaviorExistsCheckCMD): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->isUserBehaviorExists($behaviorExistsCheckCMD);
    }
    /**
     * 用户风控查询
     *
     */
    public static function isRiskUser (): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->isRiskUser();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}