<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\BirthdayActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method joinActivityByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\JoinActivityCMD $params)
 * @method submitBlessingByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\SubmitBlessingCMD $params)
 * @method getMyBlessingsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyBlessingsCMD $params)
 * @method getMyParticipateInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyParticipateInfoCMD $params)
 * @method getBlessingsByRandomByParams(array $params)
 * @method getTopMembersByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetTopMembersCMD $params)
 * @method updateBirthdayPhotoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\UpdateBirthdayPhotoCMD $params)
 * @method getMemberBaseInfoByParams(array $params)
 */
class BirthdayActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取生日空投活动信息
     *
     * @param  int $activityId 生日空投活动id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo (int $activityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo([
                            "activityId" => $activityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 加入活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\JoinActivityCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO
     */
    public static function joinActivity (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\JoinActivityCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->joinActivity($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO"
        );
    }


    /**
     * 提交祝福
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\SubmitBlessingCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO
     */
    public static function submitBlessing (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\SubmitBlessingCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->submitBlessing($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\JoinActivityResultDTO"
        );
    }


    /**
     * 获取当前用户收到的祝福
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyBlessingsCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingListDTO
     */
    public static function getMyBlessings (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyBlessingsCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMyBlessings($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingListDTO"
        );
    }


    /**
     * 获取当前活动成员信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyParticipateInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ParticipateInfoDTO
     */
    public static function getMyParticipateInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetMyParticipateInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMyParticipateInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\ParticipateInfoDTO"
        );
    }


    /**
     * 随机当前活动下的祝福
     *
     * @param  int $activityId 生日空投活动id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingInfoDTO[]
     */
    public static function getBlessingsByRandom (int $activityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBlessingsByRandom([
                            "activityId" => $activityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\BlessingInfoDTO[]"
        );
    }

    /**
     * 获取祝福排行榜
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetTopMembersCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\TopMembersInfoDTO
     */
    public static function getTopMembers (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\GetTopMembersCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getTopMembers($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\TopMembersInfoDTO"
        );
    }


    /**
     * 更新生日照
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\UpdateBirthdayPhotoCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateBirthdayPhoto (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\CMD\UpdateBirthdayPhotoCMD $cmd) {
        return self::getClass()->updateBirthdayPhoto($cmd);
    }


    /**
     * 获取发起人基础信息
     *
     * @param  int $memberId 发起人id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\SimpleMemberInfoDTO
     */
    public static function getMemberBaseInfo (int $memberId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMemberBaseInfo([
                            "memberId" => $memberId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BirthdayActivity\DTO\SimpleMemberInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\BirthdayActivity\BirthdayActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\BirthdayActivity\BirthdayActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}