<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\CrmSetting;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createCrmSettingByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\CrmSetting\CMD\SaveCrmSettingCMD $params)
 * @method updateCrmSettingByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\CrmSetting\CMD\SaveCrmSettingCMD $params)
 */
class CrmSettingManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建CrmSetting
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\CrmSetting\CMD\SaveCrmSettingCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createCrmSetting (\Mainto\Bridge\Structs\ProjectCrm\Manage\CrmSetting\CMD\SaveCrmSettingCMD $cmd) {
        return self::getClass()->createCrmSetting($cmd);
    }


    /**
     * 更新CrmSetting
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\CrmSetting\CMD\SaveCrmSettingCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateCrmSetting (\Mainto\Bridge\Structs\ProjectCrm\Manage\CrmSetting\CMD\SaveCrmSettingCMD $cmd) {
        return self::getClass()->updateCrmSetting($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\CrmSetting\CrmSettingManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\CrmSetting\CrmSettingManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}