<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\CpMemberActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCpMemberScoreLogsListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\Cmd\CpMemberScoreLogCmd $params)
 */
class CpMemberScoreLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取情侣会员分值记录日志
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\Cmd\CpMemberScoreLogCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\DTO\CpMemberScoreLogsListDTO
     */
    public static function getCpMemberScoreLogsList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\Cmd\CpMemberScoreLogCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberScoreLogsList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\DTO\CpMemberScoreLogsListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\CpMemberActivity\CpMemberScoreLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\CpMemberActivity\CpMemberScoreLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}