<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ActivityTopic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivityTopic\Cmd\ActivityTopicListCmd $params)
 * @method getTopicByRandomByParams(array $params)
 */
class ActivityTopic {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取活动主题列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivityTopic\Cmd\ActivityTopicListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivityTopic\DTO\ActivityTopicListDTO
     */
    public static function getList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivityTopic\Cmd\ActivityTopicListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ActivityTopic\DTO\ActivityTopicListDTO"
        );
    }


    /**
     * 随机获取一条活动主题
     *
     * @param  string $applyIn 应用于 [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getTopicByRandom (string $applyIn) {
        return self::getClass()->getTopicByRandom([
            "applyIn" => $applyIn,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\ActivityTopic\ActivityTopic');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\ActivityTopic\ActivityTopic');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}