<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createLikeRecordByParams(array $params)
 * @method rewardYearBillTimeAlbumCouponByParams(array $params)
 */
class YearBillActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户点赞时光相册
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $albumId 时光相册ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createLikeRecord (int $userId, int $albumId) {
        return self::getClass()->createLikeRecord([
            "userId" => $userId,
            "albumId" => $albumId,
        ]);
    }

    /**
     * 年度账单时光相册奖励发券
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $albumLikeCount 相册点赞数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function rewardYearBillTimeAlbumCoupon (int $userId, int $albumLikeCount) {
        return self::getClass()->rewardYearBillTimeAlbumCoupon([
            "userId" => $userId,
            "albumLikeCount" => $albumLikeCount,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\YearBillActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\YearBillActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}