<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method handleClueCollectNotifyByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ClueCollectNotifyCMD $params)
 * @method handleEarlyBirdBuyChanceExpiredNotifyByParams(array $params)
 * @method lockEarlyBirdCouponByParams(array $params)
 * @method unlockEarlyBirdWhenOrderCancelByParams(array $params)
 * @method unlockEarlyBirdWhenOrderRefundByParams(array $params)
 * @method tryCollectedAllClueByParams(array $params)
 * @method notifyActivityStartedByParams(array $params)
 * @method notifyProductOnlineByParams(array $params)
 */
class FairyTaleActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订阅的角色集齐碎片通知
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ClueCollectNotifyCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function handleClueCollectNotify (\Mainto\Bridge\Structs\ProjectCrm\Mobile\FairyTaleActivity\CMD\ClueCollectNotifyCMD $cmd) {
        return self::getClass()->handleClueCollectNotify($cmd);
    }


    /**
     * 早鸟价优惠即将过期提醒通知
     *
     * @param  array $userIds 用户ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function handleEarlyBirdBuyChanceExpiredNotify (array $userIds) {
        return self::getClass()->handleEarlyBirdBuyChanceExpiredNotify([
            "userIds" => $userIds,
        ]);
    }

    /**
     * 创建订单锁住早鸟优惠
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function lockEarlyBirdCoupon () {
        return self::getClass()->lockEarlyBirdCoupon([
        ]);
    }

    /**
     * 订单取消解锁早鸟优惠
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unlockEarlyBirdWhenOrderCancel () {
        return self::getClass()->unlockEarlyBirdWhenOrderCancel([
        ]);
    }

    /**
     * 订单退款解锁早鸟优惠
     *
     * @support  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function unlockEarlyBirdWhenOrderRefund () {
        return self::getClass()->unlockEarlyBirdWhenOrderRefund([
        ]);
    }

    /**
     * 领取碎片尝试集齐线索
     *
     * @support  int $userId 用户id [ require true ]
     * @support  int $clueId 线索id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function tryCollectedAllClue () {
        return self::getClass()->tryCollectedAllClue([
        ]);
    }

    /**
     * 通知童话季活动开始
     *
     * @support  array $userIds 用户id列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function notifyActivityStarted () {
        return self::getClass()->notifyActivityStarted([
        ]);
    }

    /**
     * 通知童话季产品上新
     *
     * @support  array $userIds 用户id列表 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function notifyProductOnline () {
        return self::getClass()->notifyProductOnline([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\FairyTaleActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\FairyTaleActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}