<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ConsumeRewardActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method joinActivityByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinActivityCMD $params)
 * @method isBehaviorAlertByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\BehaviorAlertCheckCMD $params)
 * @method getGroupUserInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\GetGroupUserInfoCMD $params)
 * @method getRewardsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\GetRewardCMD $params)
 * @method joinGroupByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinGroupCMD $params)
 * @method saveDeliveryInfoByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SaveDeliveryInfoDTO $params)
 */
class ConsumeRewardActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取消费奖励活动信息
     *
     * @param  int $activityId 消费奖励活动id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\DTO\ActivityDTO
     */
    public static function getActivityInfo (int $activityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo([
                            "activityId" => $activityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\DTO\ActivityDTO"
        );
    }

    /**
     * 参加消费奖励活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinActivityCMD $joinActivityCMD
     * @throws  \Exception
     * @return  bool
     */
    public static function joinActivity (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinActivityCMD $joinActivityCMD) {
        return self::getClass()->joinActivity($joinActivityCMD);
    }


    /**
     * 活动行为弹框
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\BehaviorAlertCheckCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function isBehaviorAlert (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\BehaviorAlertCheckCMD $cmd) {
        return self::getClass()->isBehaviorAlert($cmd);
    }


    /**
     * 获取当前活动团体成员信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\GetGroupUserInfoCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\DTO\GroupUserInfoDTO
     */
    public static function getGroupUserInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\GetGroupUserInfoCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getGroupUserInfo($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\DTO\GroupUserInfoDTO"
        );
    }


    /**
     * 获取奖励列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\GetRewardCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\DTO\RewardListDTO
     */
    public static function getRewards (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\GetRewardCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getRewards($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\DTO\RewardListDTO"
        );
    }


    /**
     * 受邀人立即加入
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinGroupCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function joinGroup (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinGroupCMD $cmd) {
        return self::getClass()->joinGroup($cmd);
    }


    /**
     * 填写收货信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SaveDeliveryInfoDTO $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function saveDeliveryInfo (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SaveDeliveryInfoDTO $cmd) {
        return self::getClass()->saveDeliveryInfo($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\ConsumeRewardActivity\ConsumeRewardActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\ConsumeRewardActivity\ConsumeRewardActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}