<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\ConsumeRewardActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendRewardsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendRewardsCMD $params)
 * @method orderSignSuccessByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\OrderSignSuccessCMD $params)
 * @method orderServiceComplectedByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\OrderServiceComplectedCMD $params)
 * @method joinGroupSuccessNotifyByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinGroupSuccessNotifyCMD $params)
 * @method sendFixedRewardSuccessNotifyByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendFixedRewardSuccessNotifyCMD $params)
 * @method sendScheduleRewardSuccessNotifyByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendScheduleRewardSuccessNotifyCMD $params)
 */
class ConsumeRewardActivityMessage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 消费奖励活动发奖励
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendRewardsCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendRewards (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendRewardsCMD $cmd) {
        return self::getClass()->sendRewards($cmd);
    }


    /**
     * 到店签到更改团体成员订单状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\OrderSignSuccessCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function orderSignSuccess (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\OrderSignSuccessCMD $cmd) {
        return self::getClass()->orderSignSuccess($cmd);
    }


    /**
     * 服务完成更改团体成员订单状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\OrderServiceComplectedCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function orderServiceComplected (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\OrderServiceComplectedCMD $cmd) {
        return self::getClass()->orderServiceComplected($cmd);
    }


    /**
     * 邀请好友成功通知
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinGroupSuccessNotifyCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function joinGroupSuccessNotify (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\JoinGroupSuccessNotifyCMD $cmd) {
        return self::getClass()->joinGroupSuccessNotify($cmd);
    }


    /**
     * 用户获得常规奖励通知
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendFixedRewardSuccessNotifyCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendFixedRewardSuccessNotify (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendFixedRewardSuccessNotifyCMD $cmd) {
        return self::getClass()->sendFixedRewardSuccessNotify($cmd);
    }


    /**
     * 活动定时大奖开奖
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendScheduleRewardSuccessNotifyCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendScheduleRewardSuccessNotify (\Mainto\Bridge\Structs\ProjectCrm\Mobile\ConsumeRewardActivity\CMD\SendScheduleRewardSuccessNotifyCMD $cmd) {
        return self::getClass()->sendScheduleRewardSuccessNotify($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\ConsumeRewardActivity\ConsumeRewardActivityMessage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\ConsumeRewardActivity\ConsumeRewardActivityMessage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}