<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\BirthdayActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createActivityByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\BirthdayActivity\CMD\CreateActivityCMD $params)
 * @method updateActivityByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\BirthdayActivity\CMD\UpdateActivityCMD $params)
 */
class BirthdayActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建生日空投活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\BirthdayActivity\CMD\CreateActivityCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createActivity (\Mainto\Bridge\Structs\ProjectCrm\Manage\BirthdayActivity\CMD\CreateActivityCMD $cmd) {
        return self::getClass()->createActivity($cmd);
    }


    /**
     * 更新生日空投活动
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\BirthdayActivity\CMD\UpdateActivityCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateActivity (\Mainto\Bridge\Structs\ProjectCrm\Manage\BirthdayActivity\CMD\UpdateActivityCMD $cmd) {
        return self::getClass()->updateActivity($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\BirthdayActivity\BirthdayActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\BirthdayActivity\BirthdayActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}