<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\ConsumeRewardActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method deleteGroupMemberByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\ConsumeRewardActivity\CMD\DeleteGroupMemberCMD $params)
 */
class ConsumeRewardActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 消费奖励活动踢人
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\ConsumeRewardActivity\CMD\DeleteGroupMemberCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteGroupMember (\Mainto\Bridge\Structs\ProjectCrm\Manage\ConsumeRewardActivity\CMD\DeleteGroupMemberCMD $cmd) {
        return self::getClass()->deleteGroupMember($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\ConsumeRewardActivity\ConsumeRewardActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\ConsumeRewardActivity\ConsumeRewardActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}