<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\CpMemberActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCpMemberActivityInfoByParams(array $params)
 * @method getCpMemberScoreCycleByParams(array $params)
 * @method isAlertByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\Cmd\CpMemberIsAlertCmd $params)
 */
class CpMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取情侣会员活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\DTO\CpMemberInfoDTO
     */
    public static function getCpMemberActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\DTO\CpMemberInfoDTO"
        );
    }

    /**
     * 获取情侣会员分值周期
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\DTO\CpMemberScoreCycleDTO
     */
    public static function getCpMemberScoreCycle () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberScoreCycle(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\DTO\CpMemberScoreCycleDTO"
        );
    }

    /**
     * 情侣会员是否弹框
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\Cmd\CpMemberIsAlertCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function isAlert (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CpMemberActivity\Cmd\CpMemberIsAlertCmd $cmd) {
        return self::getClass()->isAlert($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\CpMemberActivity\CpMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\CpMemberActivity\CpMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}