<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method activityStartNotifyByParams(array $params)
 * @method christmasProductsAreNewNotifyByParams(array $params)
 * @method earlyBirdBuyChanceExpiredNotifyToMQByParams(array $params)
 */
class FairyTaleActivityCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 10.24 19:00:00 通知一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function activityStartNotify () {
        return self::getClass()->activityStartNotify();
    }

    /**
     * 11.01 19:00:00 通知一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function christmasProductsAreNewNotify () {
        return self::getClass()->christmasProductsAreNewNotify();
    }

    /**
     * 海马体2022童话季活动期间执行
     * 10.30 20:00:00 通知一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function earlyBirdBuyChanceExpiredNotifyToMQ () {
        return self::getClass()->earlyBirdBuyChanceExpiredNotifyToMQ();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Cron\FairyTaleActivityCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Cron\FairyTaleActivityCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}