<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendCouponToSucceededUserByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\SendCouponCMD $params)
 * @method initCardForUserByParams(array $params)
 * @method batchNotifyUsersByParams(array $params)
 * @method doAutoCompoundCardByParams(array $params)
 */
class HarryPotterActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发送优惠券给合成卡片成功的用户
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\SendCouponCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function sendCouponToSucceededUser (\Mainto\Bridge\Structs\ProjectCrm\Mobile\HarryPotterActivity\CMD\SendCouponCMD $cmd) {
        return self::getClass()->sendCouponToSucceededUser($cmd);
    }


    /**
     * 为用户初始化卡片
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function initCardForUser () {
        return self::getClass()->initCardForUser([
        ]);
    }

    /**
     * 哈利波特活动通知
     *
     * @support  array $userIds 用户id列表 [ require true ]
     * @support  string $event 时间类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function batchNotifyUsers () {
        return self::getClass()->batchNotifyUsers([
        ]);
    }

    /**
     * 自动合成卡片
     *
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function doAutoCompoundCard () {
        return self::getClass()->doAutoCompoundCard([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\HarryPotterActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\HarryPotterActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}