<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\DunHuangActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method isFinishedAnswerByParams(array $params)
 * @method submitAnswerByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\CMD\SubmitAnswerCMD $params)
 * @method getActivitySettingByParams(array $params)
 * @method getUserCouponListByParams(array $params)
 * @method getUserBehaviorMapByParams(array $params)
 * @method createUserBehaviorByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\CMD\UserBehaviorCreateCMD $params)
 */
class DunHuangActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 是否完成答题
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\SubmitAnswerDetailDTO[]
     */
    public static function isFinishedAnswer () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->isFinishedAnswer(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\SubmitAnswerDetailDTO[]"
        );
    }

    /**
     * 提交答案
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\CMD\SubmitAnswerCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitAnswer (\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\CMD\SubmitAnswerCMD $cmd) {
        return self::getClass()->submitAnswer($cmd);
    }


    /**
     * 获取活动配置
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\ActivitySettingInfoDTO
     */
    public static function getActivitySetting () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivitySetting(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\ActivitySettingInfoDTO"
        );
    }

    /**
     * 获取用户优惠券列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\UserRewardDTO
     */
    public static function getUserCouponList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserCouponList(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\UserRewardDTO"
        );
    }

    /**
     * 获取用户行为记录map
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\UserBehaviorMapDTO
     */
    public static function getUserBehaviorMap () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserBehaviorMap(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\DTO\UserBehaviorMapDTO"
        );
    }

    /**
     * 创建用户行为记录
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\CMD\UserBehaviorCreateCMD $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createUserBehavior (\Mainto\Bridge\Structs\ProjectCrm\Mobile\DunHuangActivity\CMD\UserBehaviorCreateCMD $cmd) {
        return self::getClass()->createUserBehavior($cmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\DunHuangActivity\DunHuangActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\DunHuangActivity\DunHuangActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}