<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\YouthMemorialBook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPunchRecordsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\YouthMemorialBook\Cmd\PunchRecordQueryCMD $params)
 * @method rejectRecordByParams(array $params)
 */
class YouthMemorialBook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取打卡内容列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\YouthMemorialBook\Cmd\PunchRecordQueryCMD $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\YouthMemorialBook\DTO\PunchRecordsDTO
     */
    public static function getPunchRecords (\Mainto\Bridge\Structs\ProjectCrm\Manage\YouthMemorialBook\Cmd\PunchRecordQueryCMD $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPunchRecords($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\YouthMemorialBook\DTO\PunchRecordsDTO"
        );
    }


    /**
     * 驳回指定的打卡内容
     *
     * @support  int $recordId 打卡内容ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function rejectRecord () {
        return self::getClass()->rejectRecord([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\YouthMemorialBook\YouthMemorialBook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\YouthMemorialBook\YouthMemorialBook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}