<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\MessageBoard;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method getMessageListByParams(array $params)
 * @method getMyMessageListByParams(array $params)
 * @method createMessageByParams(array $params)
 */
class MessageBoard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取毕业留言板活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 查询所有用户留言列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO
     */
    public static function getMessageList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMessageList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO"
        );
    }

    /**
     * 查询我的留言板内容列表
     *
     * @support  int $page 页码 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO
     */
    public static function getMyMessageList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMyMessageList([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\MessageBoard\DTO\MessageBoardListDTO"
        );
    }

    /**
     * 创建一条留言内容
     *
     * @support  string $message 留言内容 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createMessage () {
        return self::getClass()->createMessage([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\MessageBoard\MessageBoard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\MessageBoard\MessageBoard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}