<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method getClassroomListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $params)
 * @method bindClassroomByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomBindCmd $params)
 * @method getParticipationInfoByParams(array $params)
 * @method punchInByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchInCmd $params)
 * @method updateRecordStatusByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\UpdateRecordStatusCmd $params)
 * @method getMyGraduationAlbumByParams(array $params)
 * @method getMyGraduationMomentListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\MyGraduationMomentListCmd $params)
 * @method getPunchRecordListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordListCmd $params)
 * @method getPunchRecordDetailByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordDetailCmd $params)
 */
class YouthMemorialBook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取青春纪念册活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 获取班级列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomListDTO
     */
    public static function getClassroomList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getClassroomList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomListDTO"
        );
    }


    /**
     * 绑定活动院校及班级
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomBindCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bindClassroom (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomBindCmd $cmd) {
        return self::getClass()->bindClassroom($cmd);
    }


    /**
     * 获取用户毕业季活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ParticipationInfoDTO
     */
    public static function getParticipationInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getParticipationInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ParticipationInfoDTO"
        );
    }

    /**
     * 毕业季活动打卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchInCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function punchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchInCmd $cmd) {
        return self::getClass()->punchIn($cmd);
    }


    /**
     * 更新打卡内容状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\UpdateRecordStatusCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateRecordStatus (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\UpdateRecordStatusCmd $cmd) {
        return self::getClass()->updateRecordStatus($cmd);
    }


    /**
     * 获取我的毕业相册
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\MyGraduationAlbumDTO
     */
    public static function getMyGraduationAlbum () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMyGraduationAlbum(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\MyGraduationAlbumDTO"
        );
    }

    /**
     * 获取我的毕业瞬间列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\MyGraduationMomentListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO
     */
    public static function getMyGraduationMomentList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\MyGraduationMomentListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMyGraduationMomentList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO"
        );
    }


    /**
     * 获取打卡内容列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO
     */
    public static function getPunchRecordList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPunchRecordList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListDTO"
        );
    }


    /**
     * 获取单条打卡内容详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordDetailCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListItemDTO
     */
    public static function getPunchRecordDetail (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\PunchRecordDetailCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getPunchRecordDetail($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\PunchRecordListItemDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\YouthMemorialBook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\YouthMemorialBook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}