<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method addByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\Cmd\PermissionCreateCmd $params)
 * @method deleteByParams(array $params)
 * @method getStaffsByPermissionByParams(array $params)
 */
class Permission {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取所有权限列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\DTO\PermissionDetailDTO[]
     */
    public static function list () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list(),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\DTO\PermissionDetailDTO[]"
        );
    }

    /**
     * 创建权限
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\Cmd\PermissionCreateCmd $permissionCreateCmd
     * @throws  \Exception
     * @return  int
     */
    public static function add (\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\Cmd\PermissionCreateCmd $permissionCreateCmd) {
        return self::getClass()->add($permissionCreateCmd);
    }


    /**
     * 删除权限
     *
     * @support  int $id 权限id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete () {
        return self::getClass()->delete([
        ]);
    }

    /**
     * 根据权限获取拥有该权限的所有员工
     *
     * @param  int $permission_id 权限id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\DTO\PermissionStaffInfoDTO[]
     */
    public static function getStaffsByPermission (int $permission_id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStaffsByPermission([
                            "permission_id" => $permission_id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Permission\DTO\PermissionStaffInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Auth\Permission');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Auth\Permission');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}