<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method doAfterRecordSucceededByParams(array $params)
 * @method generateActivityCouponByParams(array $params)
 */
class YouthMemorialBook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 记录打卡成功处理
     *
     * @param  int $recordId 记录id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function doAfterRecordSucceeded (int $recordId) {
        return self::getClass()->doAfterRecordSucceeded([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 协助站点点亮成功
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function generateActivityCoupon (int $userId) {
        return self::getClass()->generateActivityCoupon([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\YouthMemorialBook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\YouthMemorialBook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}