<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method getClassroomListByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $params)
 */
class YouthMemorialBook {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取青春纪念册活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 获取班级列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomListDTO
     */
    public static function getClassroomList (\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\Cmd\ClassroomListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getClassroomList($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YouthMemorialBook\DTO\ClassroomListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\YouthMemorialBook');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\YouthMemorialBook');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}