<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method canInitiateActivityByParams(array $params)
 * @method canAcceptInvitationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $params)
 * @method acceptInvitationByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $params)
 * @method getBoundRelationInfoByParams(array $params)
 * @method punchInByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $params)
 * @method applyPunchInByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $params)
 * @method getCalendarInfoByParams(array $params)
 */
class CourtActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取告白季活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 校验发起人是否能发起活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function canInitiateActivity () {
        return self::getClass()->canInitiateActivity();
    }

    /**
     * 校验受邀人是否可以与发起人绑定
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\AcceptInvitationCheckResultDTO
     */
    public static function canAcceptInvitation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->canAcceptInvitation($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\AcceptInvitationCheckResultDTO"
        );
    }


    /**
     * 受邀人接受发起人邀请
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function acceptInvitation (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\AcceptInvitationCmd $cmd) {
        return self::getClass()->acceptInvitation($cmd);
    }


    /**
     * 获取当前用户的绑定信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\BoundRelationInfoDTO
     */
    public static function getBoundRelationInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBoundRelationInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\BoundRelationInfoDTO"
        );
    }

    /**
     * 活动打卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $cmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function punchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\PunchInCmd $cmd) {
        return self::getClass()->punchIn($cmd);
    }


    /**
     * 活动补卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $cmd
     * @throws  \Exception
     * @return  int[]
     */
    public static function applyPunchIn (\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\Cmd\ApplyPunchInCmd $cmd) {
        return self::getClass()->applyPunchIn($cmd);
    }


    /**
     * 获取当前用户打卡信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CalendarInfoDTO
     */
    public static function getCalendarInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCalendarInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\CourtActivity\DTO\CalendarInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\CourtActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\CourtActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}