<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method doSponsorCertificationSucceededByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SponsorCertificationSucceededCmd $params)
 * @method receiveNewUserCouponByParams(array $params)
 */
class BestieActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 发起人认证成功处理
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SponsorCertificationSucceededCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function doSponsorCertificationSucceeded (\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\Cmd\SponsorCertificationSucceededCmd $cmd) {
        return self::getClass()->doSponsorCertificationSucceeded($cmd);
    }


    /**
     * 领取新用户拉新优惠券
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function receiveNewUserCoupon (int $userId) {
        return self::getClass()->receiveNewUserCoupon([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\BestieActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\BestieActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}