<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method imageCensorByParams(array $params)
 * @method checkIsNewUserByParams(array $params)
 * @method getUserTagGroupByParams(array $params)
 * @method getMusicsByParams(array $params)
 * @method getMomentsByParams(array $params)
 * @method createTimeAlbumByParams(array $params)
 * @method updateTimeAlbumByParams(array $params)
 * @method getUserTimeAlbumByParams(array $params)
 * @method getPhotoAlbumByParams(array $params)
 * @method getTimeSquareListByParams(array $params)
 * @method likedTimeAlbumByParams(array $params)
 * @method createUserBehaviorRecordByParams(array $params)
 * @method getUserBehaviorsByParams(array $params)
 * @method getLatestAlbumListByParams(array $params)
 * @method getTimeAlbumPosterQrcodeByParams(array $params)
 * @method shareAlbumToSquareByParams(array $params)
 * @method getProductCardReceivedNumByParams(array $params)
 * @method getYearBillActivityDateByParams(array $params)
 * @method getUserTimeAlbumCouponInfoByParams(array $params)
 * @method getUserFinishPhotosByParams(array $params)
 */
class YearBillActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 图片内容审核
     *
     * @support  string $imgUrl 图片URL路径 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function imageCensor () {
        return self::getClass()->imageCensor([
        ]);
    }

    /**
     * 校验用户是否为新用户
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkIsNewUser () {
        return self::getClass()->checkIsNewUser();
    }

    /**
     * 获取用户标签组
     *
     * @support  int $user_id 用户ID [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTagGroup () {
        return self::getClass()->getUserTagGroup([
        ]);
    }

    /**
     * 获取歌单列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\MusicConfigDetailDTO[]
     */
    public static function getMusics () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMusics(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\MusicConfigDetailDTO[]"
        );
    }

    /**
     * 获取时刻列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\MomentConfigDetailDTO[]
     */
    public static function getMoments () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMoments(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\MomentConfigDetailDTO[]"
        );
    }

    /**
     * 创建用户时光相册
     *
     * @support  int $musicId 音乐ID [ require true ]
     * @support  array $moments 用户上传的时刻列表信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function createTimeAlbum () {
        return self::getClass()->createTimeAlbum([
        ]);
    }

    /**
     * 编辑用户时光相册
     *
     * @support  int $musicId 音乐ID [ require true ]
     * @support  array $moments 用户上传的时刻列表信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function updateTimeAlbum () {
        return self::getClass()->updateTimeAlbum([
        ]);
    }

    /**
     * 获取指定用户的时光相册信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTimeAlbum () {
        return self::getClass()->getUserTimeAlbum();
    }

    /**
     * 获取指定的相册信息
     *
     * @param  int $albumId 相册ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoAlbum (int $albumId) {
        return self::getClass()->getPhotoAlbum([
            "albumId" => $albumId,
        ]);
    }

    /**
     * 获取时光广场列表信息
     *
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @support  array $excludeAlbumIds 排除的相册id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTimeSquareList () {
        return self::getClass()->getTimeSquareList([
        ]);
    }

    /**
     * 创建相册点赞记录
     *
     * @support  int $albumId 相册ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function likedTimeAlbum () {
        return self::getClass()->likedTimeAlbum([
        ]);
    }

    /**
     * 创建用户行为记录
     *
     * @support  string $behavior 用户行为 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createUserBehaviorRecord () {
        return self::getClass()->createUserBehaviorRecord([
        ]);
    }

    /**
     * 获取用户行为记录列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\UserBehaviorDTO
     */
    public static function getUserBehaviors () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserBehaviors(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\UserBehaviorDTO"
        );
    }

    /**
     * 获取最新x条相册列表
     *
     * @support  int $num 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLatestAlbumList () {
        return self::getClass()->getLatestAlbumList([
        ]);
    }

    /**
     * 获取时光相册海报二维码
     *
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function getTimeAlbumPosterQrcode () {
        return self::getClass()->getTimeAlbumPosterQrcode([
        ]);
    }

    /**
     * 分享时光相册到广场
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function shareAlbumToSquare () {
        return self::getClass()->shareAlbumToSquare();
    }

    /**
     * 获取时光相册活动产品券领取数量
     *
     * @throws  \Exception
     * @return  int
     */
    public static function getProductCardReceivedNum () {
        return self::getClass()->getProductCardReceivedNum();
    }

    /**
     * 获取时光相册活动时间
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\ActivityDateInfoDTO
     */
    public static function getYearBillActivityDate () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getYearBillActivityDate(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\YearBillActivity\DTO\ActivityDateInfoDTO"
        );
    }

    /**
     * 获取时光相册用户优惠券领取情况
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTimeAlbumCouponInfo () {
        return self::getClass()->getUserTimeAlbumCouponInfo();
    }

    /**
     * 获取用户成片列表
     *
     * @support  int $user_id 用户id [ require false ]
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserFinishPhotos () {
        return self::getClass()->getUserFinishPhotos([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\YearBillActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\YearBillActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}