<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\CourtActivity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMomentsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\CourtActivity\Cmd\MomentsCmd $params)
 * @method rejectMomentByParams(array $params)
 */
class CourtActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户打卡列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\CourtActivity\Cmd\MomentsCmd $momentsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\CourtActivity\DTO\MomentsDTO
     */
    public static function getMoments (\Mainto\Bridge\Structs\ProjectCrm\Manage\CourtActivity\Cmd\MomentsCmd $momentsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMoments($momentsCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\CourtActivity\DTO\MomentsDTO"
        );
    }


    /**
     * 驳回指定的打卡内容
     *
     * @support  int $momentId 打卡内容ID [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function rejectMoment () {
        return self::getClass()->rejectMoment([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\CourtActivity\CourtActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\CourtActivity\CourtActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}