<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method activateByParams(array $params)
 */
class CpMembersActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建情侣会员
     *
     * @param  int $userId 会员id [ require true ]
     * @param  array $skuList 订单sku信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create (int $userId, array $skuList) {
        return self::getClass()->create([
            "userId" => $userId,
            "skuList" => $skuList,
        ]);
    }

    /**
     * 激活情侣会员
     *
     * @param  string $serviceCompletedAt 订单服务完成时间 [ require true ]
     * @param  array $orderBaseInfo 订单基础信息 [ require true ]
     * @param  array $orderSkuList 订单sku信息 [ require true ]
     * @param  string $orderCreatedAt 订单创建时间--测试 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function activate (string $serviceCompletedAt, array $orderBaseInfo, array $orderSkuList, string $orderCreatedAt = '') {
        return self::getClass()->activate([
            "serviceCompletedAt" => $serviceCompletedAt,
            "orderBaseInfo" => $orderBaseInfo,
            "orderSkuList" => $orderSkuList,
            "orderCreatedAt" => $orderCreatedAt,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\CpMembersActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\CpMembersActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}