<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getActivityInfoByParams(array $params)
 * @method canInitiateCertificationByParams(array $params)
 * @method initiateCertificationByParams(array $params)
 * @method getCertificationSuccessListByParams(array $params)
 * @method isSubscribedMessageByParams(array $params)
 * @method getSponsorInitiateInfoByParams(array $params)
 * @method receiveNewUserWelfareByParams(array $params)
 * @method participateCertificationByParams(array $params)
 * @method getCertificationResultDetailByParams(array $params)
 * @method getFirstCertificationSuccessInfoByParams(array $params)
 * @method getUserBehaviorsByParams(array $params)
 * @method canParticipateCertificationByParams(array $params)
 * @method isUserCertificationSuccessByParams(array $params)
 */
class BestieActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取闺蜜认证活动信息
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ActivityInfoDTO
     */
    public static function getActivityInfo () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getActivityInfo(),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\BestieActivity\DTO\ActivityInfoDTO"
        );
    }

    /**
     * 校验发起人是否能发起活动
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function canInitiateCertification () {
        return self::getClass()->canInitiateCertification();
    }

    /**
     * 发起人发起认证
     *
     * @support  int $questionId 问题id [ require true ]
     * @support  int $answerId 答案id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function initiateCertification () {
        return self::getClass()->initiateCertification([
        ]);
    }

    /**
     * 获取认证成功列表
     *
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCertificationSuccessList () {
        return self::getClass()->getCertificationSuccessList([
        ]);
    }

    /**
     * 校验发起人是否已订阅消息
     *
     * @param  string $appName 应用名称 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isSubscribedMessage (string $appName) {
        return self::getClass()->isSubscribedMessage([
            "appName" => $appName,
        ]);
    }

    /**
     * 获取发起人发起认证的信息
     *
     * @param  int $recordId 发起人发起记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSponsorInitiateInfo (int $recordId) {
        return self::getClass()->getSponsorInitiateInfo([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 领取新人福利
     *
     * @param  string $token 校验token [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function receiveNewUserWelfare (string $token) {
        return self::getClass()->receiveNewUserWelfare([
            "token" => $token,
        ]);
    }

    /**
     * 受邀人参与认证
     *
     * @support  int $recordId 发起人发起记录id [ require true ]
     * @support  int $answerId 受邀人答案Id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function participateCertification () {
        return self::getClass()->participateCertification([
        ]);
    }

    /**
     * 获取认证结果详情
     *
     * @param  int $resultId 发起人发起记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getCertificationResultDetail (int $resultId) {
        return self::getClass()->getCertificationResultDetail([
            "resultId" => $resultId,
        ]);
    }

    /**
     * 获取首次认证成功信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getFirstCertificationSuccessInfo () {
        return self::getClass()->getFirstCertificationSuccessInfo();
    }

    /**
     * 获取用户行为记录列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserBehaviors () {
        return self::getClass()->getUserBehaviors();
    }

    /**
     * 校验受邀人能否参与当前发起人发起的认证
     *
     * @param  int $recordId 发起人发起记录id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function canParticipateCertification (int $recordId) {
        return self::getClass()->canParticipateCertification([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 校验是否是认证成功的发起人
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function isUserCertificationSuccess (int $userId) {
        return self::getClass()->isUserCertificationSuccess([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\BestieActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\BestieActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}