<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\WechatWork;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentListCmd $params)
 * @method getMomentByParams(array $params)
 * @method deleteMomentByParams(array $params)
 * @method updateMomentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentUpdateCmd $params)
 * @method createMomentByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentCreateCmd $params)
 * @method getMomentSettingByParams(array $params)
 * @method saveMomentSettingByParams(array $params)
 */
class MomentManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取企业微信朋友圈列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentListCmd $momentListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentListCmd $momentListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($momentListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentListDTO"
        );
    }


    /**
     * 获取单条企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO
     */
    public static function getMoment () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getMoment([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }

    /**
     * 删除企业微信朋友圈
     *
     * @support  int $id 朋友圈id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteMoment () {
        return self::getClass()->deleteMoment([
        ]);
    }

    /**
     * 编辑企业微信朋友圈
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentUpdateCmd $momentUpdateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO
     */
    public static function updateMoment (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentUpdateCmd $momentUpdateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->updateMoment($momentUpdateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }


    /**
     * 创建企业微信朋友圈
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentCreateCmd $momentCreateCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO
     */
    public static function createMoment (\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\Cmd\MomentCreateCmd $momentCreateCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createMoment($momentCreateCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\WechatWorkMoment\DTO\MomentDetailDTO"
        );
    }


    /**
     * 获取朋友圈页面设置
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMomentSetting () {
        return self::getClass()->getMomentSetting();
    }

    /**
     * 保存朋友圈页面设置
     *
     * @support  array $page_setting 页面配置 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function saveMomentSetting () {
        return self::getClass()->saveMomentSetting([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'WechatWork\MomentManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'WechatWork\MomentManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}