<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Auth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerListCmd $params)
 * @method createByParams(array $params)
 * @method enableByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerStatusModifyCmd $params)
 * @method detailByParams(array $params)
 * @method grantRoleByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerRoleGrantCmd $params)
 * @method grantPermissionsByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerPermissionGrantCmd $params)
 * @method searchStaffByParams(array $params)
 */
class Manager {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取管理员列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerListCmd $managerListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerListCmd $managerListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($managerListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerListDTO"
        );
    }


    /**
     * 创建管理员
     *
     * @support  int $staff_id 员工id [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 修改管理员启用状态
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerStatusModifyCmd $managerStatusModifyCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function enable (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerStatusModifyCmd $managerStatusModifyCmd) {
        return self::getClass()->enable($managerStatusModifyCmd);
    }


    /**
     * 获取管理员
     *
     * @param  int $id 管理员ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerDetailDTO
     */
    public static function detail (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\ManagerDetailDTO"
        );
    }

    /**
     * 给管理员授权角色
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerRoleGrantCmd $managerRoleGrantCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function grantRole (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerRoleGrantCmd $managerRoleGrantCmd) {
        return self::getClass()->grantRole($managerRoleGrantCmd);
    }


    /**
     * 给管理员授权权限
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerPermissionGrantCmd $managerPermissionGrantCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function grantPermissions (\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\Cmd\ManagerPermissionGrantCmd $managerPermissionGrantCmd) {
        return self::getClass()->grantPermissions($managerPermissionGrantCmd);
    }


    /**
     * 通过伙伴姓名或花名获得可能的工号
     *
     * @param  string $staff_name 伙伴姓名或花名 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\StaffInfoDTO[]
     */
    public static function searchStaff (string $staff_name) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->searchStaff([
                            "staff_name" => $staff_name,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Manager\DTO\StaffInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Auth\Manager');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Auth\Manager');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}