<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareCreateCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareUpdateCmd $params)
 * @method infoByParams(array $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareListCmd $params)
 * @method updateStateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method importOtherCouponTemplateByParams(array $params)
 * @method getAllOtherCouponTemplateByParams(array $params)
 * @method getAllProductSkuByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareProductSkuCmd $params)
 */
class MilestoneWelfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建里程碑福利
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareCreateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function create (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareCreateCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * 编辑里程碑福利
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareUpdateCmd $cmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareUpdateCmd $cmd) {
        return self::getClass()->update($cmd);
    }


    /**
     * 里程碑详情
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneWelfareInfoDTO
     */
    public static function info (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneWelfareInfoDTO"
        );
    }

    /**
     * 里程碑福利列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareListCmd $cmd
     * @throws  \Exception
     * @return  array
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareListCmd $cmd) {
        return self::getClass()->list($cmd);
    }


    /**
     * 里程碑福利上下架
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @param  string $state 上下架。up上架；down下架 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (int $id, string $state) {
        return self::getClass()->updateState([
            "id" => $id,
            "state" => $state,
        ]);
    }

    /**
     * 删除里程碑福利
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 导入三方券码模版
     *
     * @param  string $fileUrl 模版路径 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\ImportOtherCouponTemplateDTO
     */
    public static function importOtherCouponTemplate (string $fileUrl) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->importOtherCouponTemplate([
                            "fileUrl" => $fileUrl,
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\ImportOtherCouponTemplateDTO"
        );
    }

    /**
     * 获取全部三方券码模版列表
     *
     * @param  string $source 模版来源 [ require false ]
     * @param  array $aggTemplateIds 聚合模版id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllOtherCouponTemplate (string $source = 'youzan', array $aggTemplateIds = []) {
        return self::getClass()->getAllOtherCouponTemplate([
            "source" => $source,
            "aggTemplateIds" => $aggTemplateIds,
        ]);
    }

    /**
     * 零售sku筛选
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareProductSkuCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneWelfareProductSkuDTO
     */
    public static function getAllProductSku (\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\Cmd\MilestoneWelfareProductSkuCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllProductSku($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Manage\Milestone\DTO\MilestoneWelfareProductSkuDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\Milestone\MilestoneWelfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\Milestone\MilestoneWelfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}