<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Push;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createMessageTouchByParams(array $params)
 * @method editMessageTouchByParams(array $params)
 * @method cancelMessageTouchByParams(array $params)
 * @method deleteMessageTouchByParams(array $params)
 * @method messageTouchDetailByParams(array $params)
 * @method messageTouchListByParams(array $params)
 */
class MessageTouch {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建消息触达
     *
     * @support  string $task_name 任务名称 [ require true ]
     * @support  string $brand 任务名称 [ require false ]
     * @support  string $description 任务描述 [ require false ]
     * @support  string $channel 任务推送渠道 [ require true ]
     * @support  string $push_at 推送时间 [ require false ]
     * @support  array $filter_condition 筛选条件 [ require true ]
     * @support  array $push_content 推送内容 [ require true ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createMessageTouch () {
        return self::getClass()->createMessageTouch([
        ]);
    }

    /**
     * 编辑消息触达
     *
     * @support  int $task_id 任务id [ require true ]
     * @support  string $task_name 任务名称 [ require false ]
     * @support  string $description 任务描述 [ require false ]
     * @support  string $brand 任务名称 [ require false ]
     * @support  string $channel 任务推送渠道 [ require false ]
     * @support  string $push_at 推送时间 [ require false ]
     * @support  array $filter_condition 筛选条件 [ require true ]
     * @support  array $push_content 推送内容 [ require true ]
     * @support  array $extend 扩展信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function editMessageTouch () {
        return self::getClass()->editMessageTouch([
        ]);
    }

    /**
     * 消息触达取消
     *
     * @param  int $task_id task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelMessageTouch (int $task_id) {
        return self::getClass()->cancelMessageTouch([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 删除消息触达
     *
     * @param  int $task_id task_id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteMessageTouch (int $task_id) {
        return self::getClass()->deleteMessageTouch([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 消息触达详情
     *
     * @param  int $task_id task_id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTouchDetail (int $task_id) {
        return self::getClass()->messageTouchDetail([
            "task_id" => $task_id,
        ]);
    }

    /**
     * 消息触达列表
     *
     * @support  string $status task状态 [ require false ]
     * @support  string $channel task渠道 [ require false ]
     * @support  string $task_name task名称 [ require false ]
     * @support  string $start_at 开始推送时间 [ require false ]
     * @support  string $end_at 结束推送时间 [ require false ]
     * @support  int $page task名称 [ require false ]
     * @support  int $page_size task名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function messageTouchList () {
        return self::getClass()->messageTouchList([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Push\MessageTouch');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Push\MessageTouch');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}