<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\YearBill;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getTimeAlbumListByParams(array $params)
 * @method deleteAlbumByParams(array $params)
 */
class YearBillActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取时光相册列表
     *
     * @support  string $phone 手机号 [ require false ]
     * @support  string $createTimeStart 创建时间 - 开始时间范围 [ require false ]
     * @support  string $createTimeEnd 创建时间 - 结束时间范围 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTimeAlbumList () {
        return self::getClass()->getTimeAlbumList([
        ]);
    }

    /**
     * 删除指定的相册
     *
     * @param  int $albumId 相册ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteAlbum (int $albumId) {
        return self::getClass()->deleteAlbum([
            "albumId" => $albumId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\YearBill\YearBillActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\YearBill\YearBillActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}