<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardListCmd $params)
 * @method detailByParams(array $params)
 * @method bulkOpenByParams(array|\Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardOperationalCmd $params)
 * @method bulkForbiddenByParams(array|\Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardOperationalCmd $params)
 */
class MemberCardManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员卡列表--分页
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardListCmd $memberCardListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\MemberCard\DTO\MemberCardListDTO
     */
    public static function list (\Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardListCmd $memberCardListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($memberCardListCmd),
            "\Mainto\Bridge\Structs\ProjectCrm\MemberCard\DTO\MemberCardListDTO"
        );
    }


    /**
     * 获取会员卡详情
     *
     * @support  int $card_id 会员卡id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\MemberCard\DTO\MemberCardDetailDTO
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectCrm\MemberCard\DTO\MemberCardDetailDTO"
        );
    }

    /**
     * 批量开启会员卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardOperationalCmd $memberCardOperationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bulkOpen (\Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardOperationalCmd $memberCardOperationCmd) {
        return self::getClass()->bulkOpen($memberCardOperationCmd);
    }


    /**
     * 批量禁用会员卡
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardOperationalCmd $memberCardOperationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function bulkForbidden (\Mainto\Bridge\Structs\ProjectCrm\MemberCard\Cmd\MemberCardOperationalCmd $memberCardOperationCmd) {
        return self::getClass()->bulkForbidden($memberCardOperationCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Member\MemberCardManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Member\MemberCardManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}