<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method welfareExchangeByParams(array|\Mainto\Bridge\Structs\ProjectCrm\Mobile\Milestone\Cmd\WelfareExchangeCmd $params)
 */
class WelfareExchange {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 福利兑换
     *
     * @var  \Mainto\Bridge\Structs\ProjectCrm\Mobile\Milestone\Cmd\WelfareExchangeCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectCrm\Mobile\Milestone\DTO\WelfareExchangeDTO
     */
    public static function welfareExchange (\Mainto\Bridge\Structs\ProjectCrm\Mobile\Milestone\Cmd\WelfareExchangeCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->welfareExchange($cmd),
            "\Mainto\Bridge\Structs\ProjectCrm\Mobile\Milestone\DTO\WelfareExchangeDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Milestone\WelfareExchange');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Milestone\WelfareExchange');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}