<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserBehaviorsByParams(array $params)
 * @method getUserBehaviorsByUserIdByParams(array $params)
 * @method createUserBehaviorRecordByParams(array $params)
 * @method createUserBehaviorRecordByUserIdByParams(array $params)
 * @method getUserIdsByBehaviorByParams(array $params)
 * @method getActivityInfoByParams(array $params)
 * @method getPosterQrcodeByParams(array $params)
 * @method getRedEnvelopeAmountDetailsByParams(array $params)
 * @method getParticipationDetailByParams(array $params)
 * @method getAssistanceRedEnvelopeDetailByParams(array $params)
 * @method openRedEnvelopeByParams(array $params)
 * @method getUserInfoByUserIdByParams(array $params)
 */
class RedEnvelopeActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户行为记录列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserBehaviors () {
        return self::getClass()->getUserBehaviors();
    }

    /**
     * 通过userId获取用户行为记录列表
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserBehaviorsByUserId (int $userId) {
        return self::getClass()->getUserBehaviorsByUserId([
            "userId" => $userId,
        ]);
    }

    /**
     * 创建用户行为记录
     *
     * @support  string $behavior 用户行为 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createUserBehaviorRecord () {
        return self::getClass()->createUserBehaviorRecord([
        ]);
    }

    /**
     * 通过userId创建用户行为记录
     *
     * @param  string $behavior 用户行为 [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createUserBehaviorRecordByUserId (int $userId, string $behavior) {
        return self::getClass()->createUserBehaviorRecordByUserId([
            "userId" => $userId,
            "behavior" => $behavior,
        ]);
    }

    /**
     * 通过behavior获取对应的userId列表--预约端调用
     *
     * @param  string $behavior 用户行为 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserIdsByBehavior (string $behavior) {
        return self::getClass()->getUserIdsByBehavior([
            "behavior" => $behavior,
        ]);
    }

    /**
     * 获取新年活动信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getActivityInfo () {
        return self::getClass()->getActivityInfo();
    }

    /**
     * 获取红包活动分享海报二维码
     *
     * @param  int $greetingId 祝福语id [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getPosterQrcode (int $greetingId) {
        return self::getClass()->getPosterQrcode([
            "greetingId" => $greetingId,
        ]);
    }

    /**
     * 获取红包金额明细
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getRedEnvelopeAmountDetails () {
        return self::getClass()->getRedEnvelopeAmountDetails();
    }

    /**
     * 用户参与详情
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getParticipationDetail () {
        return self::getClass()->getParticipationDetail();
    }

    /**
     * 获取用户惊喜红包详情
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getAssistanceRedEnvelopeDetail () {
        return self::getClass()->getAssistanceRedEnvelopeDetail();
    }

    /**
     * 开红包
     *
     * @support  string $type 红包类型 [ require false ]
     * @support  int $fromUser 红包来源用户id [ require false ]
     * @support  int $greetingId 祝福语id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function openRedEnvelope () {
        return self::getClass()->openRedEnvelope([
        ]);
    }

    /**
     * 根据id获取用户脱敏详情
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfoByUserId (int $userId) {
        return self::getClass()->getUserInfoByUserId([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\RedEnvelopeActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\RedEnvelopeActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}