<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllProductSkuByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method infoByParams(array $params)
 * @method listByParams(array $params)
 * @method updateStateByParams(array $params)
 * @method deleteByParams(array $params)
 */
class MilestoneWelfareManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 零售sku筛选
     *
     * @support  string $skuName sku名称 [ require false ]
     * @support  string $skuCode sku code [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页N条 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllProductSku () {
        return self::getClass()->getAllProductSku([
        ]);
    }

    /**
     * 创建里程碑福利
     *
     * @support  int $milestoneId 里程碑阶梯id [ require true ]
     * @support  string $name 福利名称 [ require false ]
     * @support  string $preferentialType 福利类型 [ require false ]
     * @support  int $count 库存。-1表示无限 [ require false ]
     * @support  array $memberLevel 等级 [ require false ]
     * @support  int $initCount 兑换人数假数据 [ require true ]
     * @support  int $sort 排序值 [ require true ]
     * @support  array $extend 扩展数据 [ require true ]
     * @support  string $state 上下架状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑里程碑福利
     *
     * @support  int $id 里程碑福利id [ require true ]
     * @support  string $name 福利名称 [ require false ]
     * @support  string $preferentialType 福利类型 [ require false ]
     * @support  int $count 库存。-1表示无限 [ require false ]
     * @support  int $isResetInventory 是否重置库存 [ require false ]
     * @support  array $memberLevel 等级 [ require false ]
     * @support  int $initCount 兑换人数假数据 [ require true ]
     * @support  int $sort 排序值 [ require true ]
     * @support  array $extend 扩展数据 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 里程碑福利详情
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 里程碑福利列表
     *
     * @support  int $milestoneId 里程碑id [ require true ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页N条 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 里程碑福利上下架
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @param  string $state 上下架。up上架；down下架 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (int $id, string $state) {
        return self::getClass()->updateState([
            "id" => $id,
            "state" => $state,
        ]);
    }

    /**
     * 删除里程碑福利
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\Milestone\MilestoneWelfareManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\Milestone\MilestoneWelfareManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}