<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Member;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getPointClearedByParams(array $params)
 * @method clearedMemberPointByParams(array $params)
 */
class MemberPoints {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员即将积分清零信息
     *
     * @param  int $memberId 会员id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPointCleared (int $memberId) {
        return self::getClass()->getPointCleared([
            "memberId" => $memberId,
        ]);
    }

    /**
     * 清除指定阶段会员积分
     *
     * @param  int $memberId 会员id [ require true ]
     * @param  string $pointClearedTime 积分清零时间 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function clearedMemberPoint (int $memberId, string $pointClearedTime) {
        return self::getClass()->clearedMemberPoint([
            "memberId" => $memberId,
            "pointClearedTime" => $pointClearedTime,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Member\MemberPoints');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Member\MemberPoints');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}