<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method sendMemberCouponByParams(array $params)
 * @method sendBirthCouponByParams(array $params)
 */
class Member {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 处理发送会员加修加印券事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendMemberCoupon () {
        return self::getClass()->sendMemberCoupon([
        ]);
    }

    /**
     * 发送生日礼遇
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $birthDay 用户更改之后的生日。md展示 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendBirthCoupon () {
        return self::getClass()->sendBirthCoupon([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\Member');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\Member');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}