<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method imageCensorByParams(array $params)
 * @method checkIsNewUserByParams(array $params)
 * @method getUserTagGroupByParams(array $params)
 * @method getMusicsByParams(array $params)
 * @method getMomentsByParams(array $params)
 * @method createTimeAlbumByParams(array $params)
 * @method getUserTimeAlbumByParams(array $params)
 * @method getPhotoAlbumByParams(array $params)
 * @method getTimeSquareListByParams(array $params)
 * @method likedTimeAlbumByParams(array $params)
 * @method createUserBehaviorRecordByParams(array $params)
 * @method getUserBehaviorsByParams(array $params)
 * @method getLatestAlbumListByParams(array $params)
 * @method getTimeAlbumPosterQrcodeByParams(array $params)
 * @method shareAlbumToSquareByParams(array $params)
 */
class YearBillActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 图片内容审核
     *
     * @support  string $imgUrl 图片URL路径 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function imageCensor () {
        return self::getClass()->imageCensor([
        ]);
    }

    /**
     * 校验用户是否为新用户
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function checkIsNewUser () {
        return self::getClass()->checkIsNewUser();
    }

    /**
     * 获取用户标签组
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTagGroup () {
        return self::getClass()->getUserTagGroup();
    }

    /**
     * 获取歌单列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMusics () {
        return self::getClass()->getMusics();
    }

    /**
     * 获取时刻列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getMoments () {
        return self::getClass()->getMoments();
    }

    /**
     * 创建用户时光相册
     *
     * @support  int $musicId 音乐ID [ require true ]
     * @support  array $moments 用户上传的时刻列表信息 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function createTimeAlbum () {
        return self::getClass()->createTimeAlbum([
        ]);
    }

    /**
     * 获取指定用户的时光相册信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserTimeAlbum () {
        return self::getClass()->getUserTimeAlbum();
    }

    /**
     * 获取指定的相册信息
     *
     * @param  int $albumId 相册ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPhotoAlbum (int $albumId) {
        return self::getClass()->getPhotoAlbum([
            "albumId" => $albumId,
        ]);
    }

    /**
     * 获取时光广场列表信息
     *
     * @support  int $page 当前页 [ require false ]
     * @support  int $pageSize 每页多少条 [ require false ]
     * @support  array $excludeAlbumIds 排除的相册id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getTimeSquareList () {
        return self::getClass()->getTimeSquareList([
        ]);
    }

    /**
     * 创建相册点赞记录
     *
     * @support  int $albumId 相册ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function likedTimeAlbum () {
        return self::getClass()->likedTimeAlbum([
        ]);
    }

    /**
     * 创建用户行为记录
     *
     * @support  string $behavior 用户行为 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createUserBehaviorRecord () {
        return self::getClass()->createUserBehaviorRecord([
        ]);
    }

    /**
     * 获取用户行为记录列表
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserBehaviors () {
        return self::getClass()->getUserBehaviors();
    }

    /**
     * 获取最新x条相册列表
     *
     * @support  int $num 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLatestAlbumList () {
        return self::getClass()->getLatestAlbumList([
        ]);
    }

    /**
     * 获取时光相册海报二维码
     *
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function getTimeAlbumPosterQrcode () {
        return self::getClass()->getTimeAlbumPosterQrcode([
        ]);
    }

    /**
     * 分享时光相册到广场
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function shareAlbumToSquare () {
        return self::getClass()->shareAlbumToSquare();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Activity\YearBillActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Activity\YearBillActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}