<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Activity;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getParticipateDetailByParams(array $params)
 * @method checkUserBeforeJoinByParams(array $params)
 * @method getLotteryWinnerListByParams(array $params)
 * @method getUserUnsharedOrderNumByParams(array $params)
 */
class LotteryActivity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取抽奖活动参与信息
     *
     * @param  int $activityId 活动id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getParticipateDetail (int $activityId) {
        return self::getClass()->getParticipateDetail([
            "activityId" => $activityId,
        ]);
    }

    /**
     * 加入抽奖活动前校验用户
     *
     * @support  int $activityId 活动id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function checkUserBeforeJoin () {
        return self::getClass()->checkUserBeforeJoin([
        ]);
    }

    /**
     * 获取中奖用户列表--分页
     *
     * @param  int $activityId 活动id [ require true ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getLotteryWinnerList (int $activityId, int $page = 1, int $pageSize = 20) {
        return self::getClass()->getLotteryWinnerList([
            "activityId" => $activityId,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取用户未完成分享秀的订单号(from cache)
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUserUnsharedOrderNum () {
        return self::getClass()->getUserUnsharedOrderNum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Activity\LotteryActivity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Activity\LotteryActivity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}