<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method handleActivityOrderPaidByParams(array $params)
 * @method handleActivityOrderRefundByParams(array $params)
 * @method handleActivityOrderCancelByParams(array $params)
 * @method inviteeJoinRewardSponsorByParams(array $params)
 * @method resetMemberEffectiveTimeByParams(array $params)
 * @method handleActivityPeriodExpireByParams(array $params)
 * @method handleActivityOrderServiceCompletedByParams(array $params)
 * @method handleActivityWechatWorkCallbackByParams(array $params)
 * @method distributeLotteryAwardByParams(array $params)
 * @method updateLotteryActivityMemberUserLevelByParams(array $params)
 */
class Activity {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 处理活动订单支付成功事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderPaid () {
        return self::getClass()->handleActivityOrderPaid([
        ]);
    }

    /**
     * 处理活动订单退款事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $refundId 退款id [ require false ]
     * @support  int $storeId 门店id [ require false ]
     * @support  string $oriOrderStatus 源订单状态 [ require false ]
     * @support  array $orderBaseInfo 订单基础信息 [ require false ]
     * @support  array $closedSaleIds 退款产品id [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderRefund () {
        return self::getClass()->handleActivityOrderRefund([
        ]);
    }

    /**
     * 处理活动订单取消事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  int $storeId 门店id [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  array $skuList sku列表 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderCancel () {
        return self::getClass()->handleActivityOrderCancel([
        ]);
    }

    /**
     * 受邀者加入奖励发起者
     *
     * @support  array $invitee 受邀人数据 [ require true ]
     * @support  array $sponsor 邀请人数据 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function inviteeJoinRewardSponsor () {
        return self::getClass()->inviteeJoinRewardSponsor([
        ]);
    }

    /**
     * 重置活动发起人的活动有效时间
     *
     * @support  array $sponsors 活动成员 [ require true ]
     * @support  string $effectiveEndedTime 截止的活动有效时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetMemberEffectiveTime () {
        return self::getClass()->resetMemberEffectiveTime([
        ]);
    }

    /**
     * 处理发起人活动周期到期的schedule
     *
     * @support  array $schedule 活动schdule [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityPeriodExpire () {
        return self::getClass()->handleActivityPeriodExpire([
        ]);
    }

    /**
     * 处理活动订单服务完成事件
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  array $orderBaseInfo 订单基础信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function handleActivityOrderServiceCompleted () {
        return self::getClass()->handleActivityOrderServiceCompleted([
        ]);
    }

    /**
     * 处理企业微信回调事件
     *
     * @support  string $toUserName 企业微信CorpID [ require true ]
     * @support  string $fromUserName 固定为sys [ require true ]
     * @support  int $createTime 消息创建时间 [ require true ]
     * @support  string $msgType 消息的类型，固定为event [ require true ]
     * @support  string $event 事件的类型，固定为change_external_contact [ require true ]
     * @support  string $changeType 对应事件标志 [ require true ]
     * @support  string $userId 企业服务人员的UserID [ require true ]
     * @support  string $externalUserId 外部联系人的userid，注意不是企业成员的帐号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function handleActivityWechatWorkCallback () {
        return self::getClass()->handleActivityWechatWorkCallback([
        ]);
    }

    /**
     * 抽奖活动开奖奖品分发事件
     *
     * @support  int $activityId 抽奖活动id [ require true ]
     * @support  array $userIds 抽奖活动参与用户id列表 [ require true ]
     * @support  array $awardInfo 奖品信息 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function distributeLotteryAward () {
        return self::getClass()->distributeLotteryAward([
        ]);
    }

    /**
     * 会员等级变动，更新抽奖用户的会员等级冗余字段
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  string $currentLevel 类型 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateLotteryActivityMemberUserLevel (int $userId, string $currentLevel) {
        return self::getClass()->updateLotteryActivityMemberUserLevel([
            "userId" => $userId,
            "currentLevel" => $currentLevel,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'MessageHook\Activity');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'MessageHook\Activity');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}