<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Foreign;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserInfoByParams(array $params)
 * @method getWeiXinJsSdkConfigByParams(array $params)
 * @method getTempMaterialByParams(array $params)
 */
class BirthdayWishes {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户信息
     *
     * @throws  \Exception
     * @return  array
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 获取微信js-sdk配置
     *
     * @support  string $url 页面地址 [ require true ]
     * @support  string $scene 场景 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getWeiXinJsSdkConfig () {
        return self::getClass()->getWeiXinJsSdkConfig([
        ]);
    }

    /**
     * 获取临时素材
     *
     * @support  string $appName 应用名称 [ require true ]
     * @support  string $mediaId 媒体文件ID [ require false ]
     * @throws  \Exception
     * @return  string
     */
    public static function getTempMaterial () {
        return self::getClass()->getTempMaterial([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Foreign\BirthdayWishes');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Foreign\BirthdayWishes');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}