<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Mobile\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMilestoneWelfareByUserIdByParams(array $params)
 * @method getMilestoneWelfareListByParams(array $params)
 * @method infoByParams(array $params)
 * @method exchangeByParams(array $params)
 * @method getExchangedMilestoneWelfareListByParams(array $params)
 * @method getStoresByRetailSkuIdByParams(array $params)
 * @method getExchangedRetailInfoByParams(array $params)
 */
class MilestoneWelfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据用户积分获取最近的里程碑福利
     *
     * @support  int $quantity 获取N条 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMilestoneWelfareByUserId () {
        return self::getClass()->getMilestoneWelfareByUserId([
        ]);
    }

    /**
     * 获取里程碑福利
     *
     * @support  int $milestoneId 里程碑阶梯id [ require false ]
     * @support  array $sortBy 排序 [ require false ]
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMilestoneWelfareList () {
        return self::getClass()->getMilestoneWelfareList([
        ]);
    }

    /**
     * 获取福利详情
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 里程碑福利兑换
     *
     * @support  int $welfareId 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function exchange () {
        return self::getClass()->exchange([
        ]);
    }

    /**
     * 用户已兑福利
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExchangedMilestoneWelfareList () {
        return self::getClass()->getExchangedMilestoneWelfareList([
        ]);
    }

    /**
     * 根据零售sku_id获取门店信息
     *
     * @param  int $skuId 零售sku_id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getStoresByRetailSkuId (int $skuId) {
        return self::getClass()->getStoresByRetailSkuId([
            "skuId" => $skuId,
        ]);
    }

    /**
     * 零售提货页信息
     *
     * @support  int $welfareId 里程碑福利id [ require true ]
     * @support  string $orderNo 零售提货订单号 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getExchangedRetailInfo () {
        return self::getClass()->getExchangedRetailInfo([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Mobile\Milestone\MilestoneWelfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Mobile\Milestone\MilestoneWelfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}