<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Milestone;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getByParams(array $params)
 * @method listByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 */
class MilestoneManage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取单条里程碑
     *
     * @support  int $id 里程碑id [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function get () {
        return self::getClass()->get([
        ]);
    }

    /**
     * 里程碑列表 -- 分页
     *
     * @support  int $page 页数 [ require false ]
     * @support  int $page_size 分页数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 创建里程碑
     *
     * @support  string $name 名称 [ require false ]
     * @support  int $score 纪念值 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑里程碑
     *
     * @support  int $id 里程碑id [ require false ]
     * @support  string $name 名称 [ require false ]
     * @support  int $score 纪念值 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Milestone\MilestoneManage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Milestone\MilestoneManage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}