<?php
namespace Mainto\Bridge\Invokes\ProjectCrm\Manage;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createActiveByParams(array $params)
 * @method searchActiveByParams(array $params)
 * @method copyActivityPageByIdByParams(array $params)
 * @method searchByIdByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method upDownActivePageByParams(array $params)
 */
class ActivityPage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建一个活动
     *
     * @support  string $category 分类 [ require true ]
     * @support  string $name 活动名称 [ require true ]
     * @support  string $template 模板key [ require true ]
     * @support  array $extend 扩展信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createActive () {
        return self::getClass()->createActive([
        ]);
    }

    /**
     * 活动查询
     *
     * @support  string $category 分类 [ require false ]
     * @support  string $name 活动名称 [ require false ]
     * @support  int $number 活动编号 [ require false ]
     * @support  string $template 模板key [ require false ]
     * @support  int $page 页码 [ require false ]
     * @support  int $page_size 每页数量 [ require false ]
     * @support  bool $all 是否返回所有结果 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function searchActive () {
        return self::getClass()->searchActive([
        ]);
    }

    /**
     * 复制单个活动
     *
     * @support  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function copyActivityPageById () {
        return self::getClass()->copyActivityPageById([
        ]);
    }

    /**
     * 单个活动查询
     *
     * @param  string $_id _id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function searchById (string $_id) {
        return self::getClass()->searchById([
            "_id" => $_id,
        ]);
    }

    /**
     * 更新活动
     *
     * @support  string $_id id [ require true ]
     * @support  string $category 分类 [ require false ]
     * @support  string $name 活动名称 [ require false ]
     * @support  string $template 模板key [ require false ]
     * @support  int $auditor 审核者 [ require false ]
     * @support  array $extend 扩展信息 [ require false ]
     * @support  string $link 活动页面链接 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update([
        ]);
    }

    /**
     * 删除活动
     *
     * @param  string $_id id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (string $_id) {
        return self::getClass()->delete([
            "_id" => $_id,
        ]);
    }

    /**
     * 上线或下线活动
     *
     * @param  string $_id id [ require true ]
     * @param  string $page_state 页面上线状态 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function upDownActivePage (string $_id, string $page_state) {
        return self::getClass()->upDownActivePage([
            "_id" => $_id,
            "page_state" => $page_state,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectCrm', 'Manage\ActivityPage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectCrm', 'Manage\ActivityPage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}